/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.util.Log;
import com.gprinter.model.PrinterStatus;
import com.gprinter.printer.DeviceInfoManager;
import com.gprinter.printer.PrinterManager;
import com.gprinter.service.PrinterStatusBroadcastReceiver;
import com.gprinter.service.SendDeviceInfoThread;
import com.gprinter.service.UpDeviceStatusThread;
import com.gprinter.util.LogInfo;

public class AllService
extends Service {
    private PrinterManager mPrinterManager;
    private DeviceInfoManager mDeviceInfoManager;
    private PrinterStatusBroadcastReceiver printerStatusBroadcastReceiver = null;
    private UpDeviceStatusThread mUpDeviceStatusThread;
    private SendDeviceInfoThread mSendDeviceInfoThread;
    private PrinterStatus mPrinterStatus = new PrinterStatus();
    public static final String TAG = "--ALLService--";
    PowerManager.WakeLock wakeLock = null;

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"onCreate()");
        this.acquireWakeLock();
        LogInfo.setContext((Context)this);
        this.startPrinterConnect();
        this.mDeviceInfoManager = DeviceInfoManager.getDeviceInfoManager((Context)this);
        this.mUpDeviceStatusThread = new UpDeviceStatusThread(this, this.mPrinterStatus);
        this.mUpDeviceStatusThread.start();
        SharedPreferences sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)this);
        boolean ischeck = sharedPreference.getBoolean("key_ischecked", true);
        SendDeviceInfoThread.isChecked(ischeck);
        this.mSendDeviceInfoThread = new SendDeviceInfoThread(this);
        this.mSendDeviceInfoThread.start();
    }

    public void startPrinterConnect() {
        if (this.printerStatusBroadcastReceiver != null) {
            this.unregisterReceiver(this.printerStatusBroadcastReceiver);
            this.printerStatusBroadcastReceiver = null;
        }
        this.printerStatusBroadcastReceiver = new PrinterStatusBroadcastReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("action.connect.status");
        this.registerReceiver(this.printerStatusBroadcastReceiver, filter);
        this.mPrinterManager = PrinterManager.getPrinterManager((Context)this);
        this.mPrinterManager.start();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LogInfo.out("-Service onStartCommand-");
        return 1;
    }

    public void onDestroy() {
        this.mUpDeviceStatusThread.setStop(true);
        this.mSendDeviceInfoThread.setStop(true);
        if (this.mPrinterManager != null) {
            this.mPrinterManager.stop();
        }
        if (this.printerStatusBroadcastReceiver != null) {
            this.unregisterReceiver(this.printerStatusBroadcastReceiver);
            this.printerStatusBroadcastReceiver = null;
        }
        if (this.mUpDeviceStatusThread.mBroadcastReceiver != null) {
            this.unregisterReceiver(this.mUpDeviceStatusThread.mBroadcastReceiver);
        }
        Intent localIntent = new Intent();
        localIntent.setClass((Context)this, AllService.class);
        this.startService(localIntent);
        this.releaseWakeLock();
        super.onDestroy();
    }

    public PrinterManager getmPrinterManager() {
        return this.mPrinterManager;
    }

    public void setmPrinterManager(PrinterManager mPrinterManager) {
        this.mPrinterManager = mPrinterManager;
    }

    public DeviceInfoManager getDeviceInfoManager() {
        return this.mDeviceInfoManager;
    }

    public void setDeviceInfoManager(DeviceInfoManager deviceInfoManager) {
        this.mDeviceInfoManager = deviceInfoManager;
    }

    private void acquireWakeLock() {
        if (this.wakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.wakeLock = pm.newWakeLock(0x20000001, "PostLocationService");
            if (this.wakeLock != null) {
                this.wakeLock.acquire();
            }
        }
    }

    private void releaseWakeLock() {
        if (this.wakeLock != null) {
            this.wakeLock.release();
            this.wakeLock = null;
        }
    }
}

